/*
 * Decompiled with CFR 0.152.
 */
package com.fizzware.dramaticdoors.forge.forge.datagen;

import com.fizzware.dramaticdoors.forge.blocks.ShortDoorBlock;
import com.fizzware.dramaticdoors.forge.blocks.TallDoorBlock;
import com.fizzware.dramaticdoors.forge.state.properties.TripleBlockPart;
import net.minecraft.core.Direction;
import net.minecraft.data.DataGenerator;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.properties.DoorHingeSide;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.client.model.generators.BlockModelBuilder;
import net.minecraftforge.client.model.generators.BlockStateProvider;
import net.minecraftforge.client.model.generators.ConfiguredModel;
import net.minecraftforge.client.model.generators.ModelBuilder;
import net.minecraftforge.client.model.generators.ModelFile;
import net.minecraftforge.common.data.ExistingFileHelper;
import net.minecraftforge.registries.ForgeRegistries;

public class DDBlockStateProvider
extends BlockStateProvider {
    public DDBlockStateProvider(DataGenerator gen, ExistingFileHelper exFileHelper) {
        super(gen, "dramaticdoors", exFileHelper);
    }

    protected void registerStatesAndModels() {
        this.shortDoorBlock((Block)ForgeRegistries.BLOCKS.getValue(new ResourceLocation("dramaticdoors", "short_birch_door")), "block/short_birch");
        this.tallDoorBlock((Block)ForgeRegistries.BLOCKS.getValue(new ResourceLocation("dramaticdoors", "tall_birch_door")), "block/tall_birch");
    }

    private void tallDoorBlock(Block block, String baseName) {
        this.internalTallDoorBlock((TallDoorBlock)block, baseName, new ResourceLocation("dramaticdoors", baseName + "_door_bottom"), new ResourceLocation("dramaticdoors", baseName + "_door_middle"), new ResourceLocation("dramaticdoors", baseName + "_door_top"));
    }

    private void shortDoorBlock(Block block, String baseName) {
        this.internalShortDoorBlock((ShortDoorBlock)block, baseName, new ResourceLocation("dramaticdoors", baseName + "_door"));
    }

    private void internalTallDoorBlock(TallDoorBlock block, String baseName, ResourceLocation bottom, ResourceLocation middle, ResourceLocation top) {
        ModelBuilder bottomLeft = ((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)this.models().withExistingParent(baseName + "_door_bottom_left", ":block/door_bottom_left")).texture("bottom", bottom)).texture("middle", middle)).texture("top", top);
        ModelBuilder bottomLeftOpen = ((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)this.models().withExistingParent(baseName + "_door_bottom_left_open", "block/door_bottom_left_open")).texture("bottom", bottom)).texture("middle", middle)).texture("top", top);
        ModelBuilder bottomRight = ((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)this.models().withExistingParent(baseName + "_door_bottom_right", "block/door_bottom_right")).texture("bottom", bottom)).texture("middle", middle)).texture("top", top);
        ModelBuilder bottomRightOpen = ((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)this.models().withExistingParent(baseName + "_door_bottom_right_open", "block/door_bottom_right_open")).texture("bottom", bottom)).texture("middle", middle)).texture("top", top);
        ModelBuilder middleLeft = ((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)this.models().withExistingParent(baseName + "_door_middle_left", "dramaticdoors:block/door_middle_left")).texture("bottom", middle)).texture("middle", middle)).texture("top", middle);
        ModelBuilder middleLeftOpen = ((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)this.models().withExistingParent(baseName + "_door_middle_left_open", "dramaticdoors:block/door_middle_left_open")).texture("bottom", middle)).texture("middle", middle)).texture("top", middle);
        ModelBuilder middleRight = ((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)this.models().withExistingParent(baseName + "_door_middle_right", "dramaticdoors:block/door_middle_right")).texture("bottom", middle)).texture("middle", middle)).texture("top", middle);
        ModelBuilder middleRightOpen = ((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)this.models().withExistingParent(baseName + "_door_middle_right_open", "dramaticdoors:block/door_middle_right_open")).texture("bottom", middle)).texture("middle", middle)).texture("top", middle);
        ModelBuilder topLeft = ((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)this.models().withExistingParent(baseName + "_door_top_left", "block/door_top_left")).texture("bottom", bottom)).texture("middle", middle)).texture("top", top);
        ModelBuilder topLeftOpen = ((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)this.models().withExistingParent(baseName + "_door_top_left_open", "block/door_top_left_open")).texture("bottom", bottom)).texture("middle", middle)).texture("top", top);
        ModelBuilder topRight = ((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)this.models().withExistingParent(baseName + "_door_top_right", "block/door_top_right")).texture("bottom", bottom)).texture("middle", middle)).texture("top", top);
        ModelBuilder topRightOpen = ((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)this.models().withExistingParent(baseName + "_door_top_right_open", "block/door_top_right_open")).texture("bottom", bottom)).texture("middle", middle)).texture("top", top);
        this.tallDoorBlock(block, (ModelFile)bottomLeft, (ModelFile)bottomLeftOpen, (ModelFile)bottomRight, (ModelFile)bottomRightOpen, (ModelFile)middleLeft, (ModelFile)middleLeftOpen, (ModelFile)middleRight, (ModelFile)middleRightOpen, (ModelFile)topLeft, (ModelFile)topLeftOpen, (ModelFile)topRight, (ModelFile)topRightOpen);
    }

    private void internalShortDoorBlock(ShortDoorBlock block, String baseName, ResourceLocation tex) {
        ModelBuilder left = ((BlockModelBuilder)this.models().withExistingParent(baseName + "_door_left", "dramaticdoors:block/door_short_left")).texture("texture", tex);
        ModelBuilder leftOpen = ((BlockModelBuilder)this.models().withExistingParent(baseName + "_door_left_open", "dramaticdoors:block/door_short_left_open")).texture("texture", tex);
        ModelBuilder right = ((BlockModelBuilder)this.models().withExistingParent(baseName + "_door_right", "dramaticdoors:block/door_short_right")).texture("texture", tex);
        ModelBuilder rightOpen = ((BlockModelBuilder)this.models().withExistingParent(baseName + "_door_right_open", "dramaticdoors:block/door_short_right_open")).texture("texture", tex);
        this.shortDoorBlock(block, (ModelFile)left, (ModelFile)leftOpen, (ModelFile)right, (ModelFile)rightOpen);
    }

    public void tallDoorBlock(TallDoorBlock block, ModelFile bottomLeft, ModelFile bottomLeftOpen, ModelFile bottomRight, ModelFile bottomRightOpen, ModelFile middleLeft, ModelFile middleLeftOpen, ModelFile middleRight, ModelFile middleRightOpen, ModelFile topLeft, ModelFile topLeftOpen, ModelFile topRight, ModelFile topRightOpen) {
        this.getVariantBuilder(block).forAllStatesExcept(state -> {
            int yRot = (int)((Direction)state.m_61143_((Property)TallDoorBlock.FACING)).m_122435_() + 90;
            TripleBlockPart third = (TripleBlockPart)((Object)((Object)state.m_61143_(TallDoorBlock.THIRD)));
            boolean right = state.m_61143_(TallDoorBlock.HINGE) == DoorHingeSide.RIGHT;
            boolean open = (Boolean)state.m_61143_((Property)TallDoorBlock.OPEN);
            if (open) {
                yRot += 90;
            }
            if (right && open) {
                yRot += 180;
            }
            yRot %= 360;
            ModelFile model = null;
            switch (third) {
                default: {
                    if (right && open) {
                        model = bottomRightOpen;
                    } else if (!right && open) {
                        model = bottomLeftOpen;
                    }
                    if (right && !open) {
                        model = bottomRight;
                        break;
                    }
                    if (right || open) break;
                    model = bottomLeft;
                    break;
                }
                case MIDDLE: {
                    if (right && open) {
                        model = middleRightOpen;
                    } else if (!right && open) {
                        model = middleLeftOpen;
                    }
                    if (right && !open) {
                        model = middleRight;
                        break;
                    }
                    if (right || open) break;
                    model = middleLeft;
                    break;
                }
                case UPPER: {
                    if (right && open) {
                        model = topRightOpen;
                    } else if (!right && open) {
                        model = topLeftOpen;
                    }
                    if (right && !open) {
                        model = topRight;
                        break;
                    }
                    if (right || open) break;
                    model = topLeft;
                }
            }
            return ConfiguredModel.builder().modelFile(model).rotationY(yRot).build();
        }, new Property[]{TallDoorBlock.POWERED, TallDoorBlock.WATERLOGGED});
    }

    public void shortDoorBlock(ShortDoorBlock block, ModelFile left, ModelFile leftOpen, ModelFile right, ModelFile rightOpen) {
        this.getVariantBuilder(block).forAllStatesExcept(state -> {
            int yRot = (int)((Direction)state.m_61143_((Property)ShortDoorBlock.FACING)).m_122435_() + 90;
            boolean isRight = state.m_61143_(ShortDoorBlock.HINGE) == DoorHingeSide.RIGHT;
            boolean open = (Boolean)state.m_61143_((Property)ShortDoorBlock.OPEN);
            if (open) {
                yRot += 90;
            }
            if (isRight && open) {
                yRot += 180;
            }
            ModelFile model = null;
            model = isRight ? (open ? rightOpen : right) : (open ? leftOpen : left);
            return ConfiguredModel.builder().modelFile(model).rotationY(yRot %= 360).build();
        }, new Property[]{ShortDoorBlock.POWERED, TallDoorBlock.WATERLOGGED});
    }
}

